<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
    <xsl:param name="xslShowHelp" select="cif:xslShowHelp"/>
    <xsl:param name="xslRootDirectory" select="cif:xslRootDirectory"/>
    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))"/>
        <html>
            <head>
                <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
                <title lang="en">Výpis Směrové prvky XYZ</title>
            </head>
            <body>
                <xsl:choose>
                    <xsl:when test="$xslShowHelp = 'true'">
                        <xsl:call-template name="StyleSheetHelp"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:for-each select="InRoads">
                            <center>
                                <h2 lang="en">Výpis Směrové prvky XYZ</h2>
                                <p lang="en">
                                    Datum výpisu:&#xa0; <xsl:value-of select="cif:date()"/><br />
                                    Čas:&#xa0; <xsl:value-of select="cif:time()"/>
                                </p>
                            </center>

                            <xsl:for-each select="GeometryProject">
                                <table class="margin" cellpadding="2" width="90%">
                                    <tbody>
                                        <tr>
                                            <th align="right" lang="en">Projekt:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@name"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Popis:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@description"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Název souboru:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@file"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Poslední revize:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="concat(@lastRevisedBy, '  ', @lastRevisedDate)"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en" style="font-size: 80%">&#xa0; </th>
                                            <td align="right" lang="en" style="font-size: 80%">
                                                <strong>Poznámka:&#xa0; </strong>Všechny jednotky v tomto výpisu jsou 
                                                <xsl:if test="//@linearUnits = 'Imperial'">ve stopách,</xsl:if>
                                                <xsl:if test="//@linearUnits = 'Metric'">v metrech,</xsl:if>
                                                pokud není specifikováno jinak.
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                <hr/>

                                <table class="margin" cellpadding="2" width="90%">
                                    <tbody>
                                        <xsl:for-each select="HorizontalAlignment">
                                            <tr>
                                                <th align="right" colspan="2" lang="en">Název trasy:</th>
                                                <td align="left" colspan="5"><xsl:value-of select="@name"/></td>
                                            </tr>
                                            <tr>
                                                <th class="underline" lang="en">Bod</th>
                                                <th class="underline" lang="en">Y<sub>s-jtsk</sub></th>
                                                <th class="underline" lang="en">X<sub>s-jtsk</sub></th>
                                                <th class="underline" lang="en">Z</th>
                                                <th class="underline" lang="en">Staničení</th>
                                                <th class="underline" lang="en">Směr</th>
                                                <th class="underline" lang="en">Poloměr</th>
                                            </tr>
                                            <xsl:for-each select="HorizontalElements">
                                                <xsl:sort select="//@internalStation" data-type="number"/>
                                                <xsl:apply-templates/>
                                            </xsl:for-each>
                                            <tr><td colspan="7">&#xa0;</td></tr>
                                        </xsl:for-each>
                                    </tbody>
                                </table>
                            </xsl:for-each>
                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </body>
        </html>
    </xsl:template>

    <xsl:template match="HorizontalLine">
        <xsl:variable name="startStation" select="Start/station/@internalStation"/>
        <xsl:variable name="endStation" select="End/station/@internalStation"/>
        <xsl:for-each select="Start">
            <tr>
                <td class="sidepad" align="left"><xsl:call-template name="Number"/></td>
                <td class="sidepad" align="right"><xsl:value-of select="cif:ordinateFormat(-1*number(@easting))"/></td>
                <td class="sidepad" align="right"><xsl:value-of select="cif:ordinateFormat(-1*number(@northing))"/></td>
                <td class="sidepad" align="right"><xsl:value-of select="cif:ordinateFormat(number(@elevation))"/></td>
                <td class="sidepad" align="right" nowrap="nowrap">
                    <xsl:value-of select="cif:stationFormat(number(station/@externalStation), string(station/@externalStationName))"/>
                </td>
                <td align="right">
                    <xsl:value-of select="cif:directionFormat(number(../@direction))"/>
                </td>
                <td/>
            </tr>
        </xsl:for-each>
        <xsl:for-each select="../../HorizontalEventPoints">
            <xsl:variable name="list1" select="*/HorizontalEventPoint[GeometryPoint/station/@internalStation &gt; $startStation]"/>
            <xsl:for-each select="$list1[GeometryPoint/station/@internalStation &lt; $endStation]">
                <tr>
                    <td class="sidepad" align="left"><xsl:call-template name="Number"/></td>
                    <td class="sidepad" align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(GeometryPoint/@easting))"/>
                    </td>
                    <td class="sidepad" align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(GeometryPoint/@northing))"/>
                    </td>
                    <td class="sidepad" align="right">
                        <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@elevation))"/>
                    </td>
                    <td class="sidepad" align="right">
                        <xsl:value-of select="cif:stationFormat(number(GeometryPoint/station/@externalStation), string(GeometryPoint/station/@externalStationName))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:directionFormat(number(@tangentialDirection))"/>
                    </td>
                    <td/>
                </tr>
            </xsl:for-each>
        </xsl:for-each>
        <xsl:for-each select="End">
            <tr>
                <td class="sidepad" align="left"><xsl:call-template name="Number"/></td>
                <td class="sidepad" align="right"><xsl:value-of select="cif:ordinateFormat(-1*number(@easting))"/></td>
                <td class="sidepad" align="right"><xsl:value-of select="cif:ordinateFormat(-1*number(@northing))"/></td>
                <td class="sidepad" align="right"><xsl:value-of select="cif:ordinateFormat(number(@elevation))"/></td>
                <td class="sidepad" align="right" nowrap="nowrap">
                    <xsl:value-of select="cif:stationFormat(number(station/@externalStation), string(station/@externalStationName))"/>
                </td>
                <td align="right">
                    <xsl:value-of select="cif:directionFormat(number(../@direction))"/>
                </td>
                <td/>
            </tr>
        </xsl:for-each>
    </xsl:template>

    <xsl:template match="HorizontalCircle">
        <xsl:variable name="startStation" select="Start/station/@internalStation"/>
        <xsl:variable name="endStation" select="End/station/@internalStation"/>
        <xsl:for-each select="Start">
            <tr>
                <td class="sidepad" align="left"><xsl:call-template name="Number"/></td>
                <td class="sidepad" align="right"><xsl:value-of select="cif:ordinateFormat(-1*number(@easting))"/></td>
                <td class="sidepad" align="right"><xsl:value-of select="cif:ordinateFormat(-1*number(@northing))"/></td>
                <td class="sidepad" align="right"><xsl:value-of select="cif:ordinateFormat(number(@elevation))"/></td>
                <td class="sidepad" align="right" nowrap="nowrap">
                    <xsl:value-of select="cif:stationFormat(number(station/@externalStation), string(station/@externalStationName))"/>
                </td>
                <td align="right">
                    <xsl:value-of select="cif:directionFormat(number(../@tangentialDirectionStart))"/>
                </td>
                <xsl:choose>
                    <xsl:when test="../@rotationDirection = 'ccw'">
                        <td align="right">
                            <xsl:value-of select="cif:distanceFormat(number(-1 * ../@radius))"/>
                        </td>
                    </xsl:when>
                    <xsl:otherwise>
                        <td align="right">
                            <xsl:value-of select="cif:distanceFormat(number(../@radius))"/>
                        </td>
                    </xsl:otherwise>
                </xsl:choose>
            </tr>
        </xsl:for-each>
        <xsl:choose>
            <xsl:when test="@rotationDirection = 'ccw'">
                <xsl:for-each select="../../HorizontalEventPoints">
                    <xsl:variable name="list1" select="*/HorizontalEventPoint[GeometryPoint/station/@internalStation &gt; $startStation]"/>
                    <xsl:for-each select="$list1[GeometryPoint/station/@internalStation &lt; $endStation]">
                        <tr>
                            <td class="sidepad" align="left"><xsl:call-template name="Number"/></td>
                            <td class="sidepad" align="right">
                                <xsl:value-of select="cif:ordinateFormat(-1*number(GeometryPoint/@easting))"/>
                            </td>
                            <td class="sidepad" align="right">
                                <xsl:value-of select="cif:ordinateFormat(-1*number(GeometryPoint/@northing))"/>
                            </td>
                            <td class="sidepad" align="right">
                                <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@elevation))"/>
                            </td>
                            <td class="sidepad" align="right">
                                <xsl:value-of select="cif:stationFormat(number(GeometryPoint/station/@externalStation), string(GeometryPoint/station/@externalStationName))"/>
                            </td>
                            <td align="right">
                                <xsl:value-of select="cif:directionFormat(number(@tangentialDirection))"/>
                            </td>
                            <td align="right">
                                <xsl:value-of select="cif:distanceFormat(number(-1 * @radius))"/>
                            </td>
                        </tr>
                    </xsl:for-each>
                </xsl:for-each>
            </xsl:when>
            <xsl:otherwise>
                <xsl:for-each select="../../HorizontalEventPoints">
                    <xsl:variable name="list1" select="*/HorizontalEventPoint[GeometryPoint/station/@internalStation &gt; $startStation]"/>
                    <xsl:for-each select="$list1[GeometryPoint/station/@internalStation &lt; $endStation]">
                        <tr>
                            <td class="sidepad" align="left"><xsl:call-template name="Number"/></td>
                            <td class="sidepad" align="right">
                                <xsl:value-of select="cif:ordinateFormat(-1*number(GeometryPoint/@easting))"/>
                            </td>
                            <td class="sidepad" align="right">
                                <xsl:value-of select="cif:ordinateFormat(-1*number(GeometryPoint/@northing))"/>
                            </td>
                            <td class="sidepad" align="right">
                                <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@elevation))"/>
                            </td>
                            <td class="sidepad" align="right">
                                <xsl:value-of select="cif:stationFormat(number(GeometryPoint/station/@externalStation), string(GeometryPoint/station/@externalStationName))"/>
                            </td>
                            <td align="right">
                                <xsl:value-of select="cif:directionFormat(number(@tangentialDirection))"/>
                            </td>
                            <td align="right">
                                <xsl:value-of select="cif:distanceFormat(number(@radius))"/>
                            </td>
                        </tr>
                    </xsl:for-each>
                </xsl:for-each>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:for-each select="End">
            <tr>
                <td class="sidepad" align="left"><xsl:call-template name="Number"/></td>
                <td class="sidepad" align="right"><xsl:value-of select="cif:ordinateFormat(-1*number(@easting))"/></td>
                <td class="sidepad" align="right"><xsl:value-of select="cif:ordinateFormat(-1*number(@northing))"/></td>
                <td class="sidepad" align="right"><xsl:value-of select="cif:ordinateFormat(number(@elevation))"/></td>
                <td class="sidepad" align="right" nowrap="nowrap">
                    <xsl:value-of select="cif:stationFormat(number(station/@externalStation), string(station/@externalStationName))"/>
                </td>
                <td align="right">
                    <xsl:value-of select="cif:directionFormat(number(../@tangentialDirectionStart))"/>
                </td>
                <xsl:choose>
                    <xsl:when test="../@rotationDirection = 'ccw'">
                        <td align="right">
                            <xsl:value-of select="cif:distanceFormat(number(-1 * ../@radius))"/>
                        </td>
                    </xsl:when>
                    <xsl:otherwise>
                        <td align="right">
                            <xsl:value-of select="cif:distanceFormat(number(../@radius))"/>
                        </td>
                    </xsl:otherwise>
                </xsl:choose>
            </tr>
        </xsl:for-each>
    </xsl:template>

    <xsl:template match="HorizontalSpiral">
        <xsl:variable name="startStation" select="Start/station/@internalStation"/>
        <xsl:variable name="endStation" select="End/station/@internalStation"/>
        <xsl:for-each select="Start">
            <tr>
                <td class="sidepad" align="left"><xsl:call-template name="Number"/></td>
                <td class="sidepad" align="right"><xsl:value-of select="cif:ordinateFormat(-1*number(@easting))"/></td>
                <td class="sidepad" align="right"><xsl:value-of select="cif:ordinateFormat(-1*number(@northing))"/></td>
                <td class="sidepad" align="right"><xsl:value-of select="cif:ordinateFormat(number(@elevation))"/></td>
                <td class="sidepad" align="right" nowrap="nowrap">
                    <xsl:value-of select="cif:stationFormat(number(station/@externalStation), string(station/@externalStationName))"/>
                </td>
                <td align="right">
                    <xsl:value-of select="cif:directionFormat(number(../@tangentialDirectionStart))"/>
                </td>
                <xsl:choose>
                    <xsl:when test="../@rotationDirection = 'ccw'">
                        <td align="right">
                            <xsl:value-of select="cif:distanceFormat(number(-1 * ../@startRadius))"/>
                        </td>
                    </xsl:when>
                    <xsl:otherwise>
                        <td align="right">
                            <xsl:value-of select="cif:distanceFormat(number(../@startRadius))"/>
                        </td>
                    </xsl:otherwise>
                </xsl:choose>
            </tr>
        </xsl:for-each>
        <xsl:choose>
            <xsl:when test="@rotationDirection = 'ccw'">
                <xsl:for-each select="../../HorizontalEventPoints">
                    <xsl:variable name="list1" select="*/HorizontalEventPoint[GeometryPoint/station/@internalStation &gt; $startStation]"/>
                    <xsl:for-each select="$list1[GeometryPoint/station/@internalStation &lt; $endStation]">
                        <tr>
                            <td class="sidepad" align="left"><xsl:call-template name="Number"/></td>
                            <td class="sidepad" align="right">
                                <xsl:value-of select="cif:ordinateFormat(-1*number(GeometryPoint/@easting))"/>
                            </td>
                            <td class="sidepad" align="right">
                                <xsl:value-of select="cif:ordinateFormat(-1*number(GeometryPoint/@northing))"/>
                            </td>
                            <td class="sidepad" align="right">
                                <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@elevation))"/>
                            </td>
                            <td class="sidepad" align="right">
                                <xsl:value-of select="cif:stationFormat(number(GeometryPoint/station/@externalStation), string(GeometryPoint/station/@externalStationName))"/>
                            </td>
                            <td align="right">
                                <xsl:value-of select="cif:directionFormat(number(@tangentialDirection))"/>
                            </td>
                            <td align="right">
                                <xsl:value-of select="cif:distanceFormat(number(-1 * @radius))"/>
                            </td>
                        </tr>
                    </xsl:for-each>
                </xsl:for-each>
            </xsl:when>
            <xsl:otherwise>
                <xsl:for-each select="../../HorizontalEventPoints">
                    <xsl:variable name="list1" select="*/HorizontalEventPoint[GeometryPoint/station/@internalStation &gt; $startStation]"/>
                    <xsl:for-each select="$list1[GeometryPoint/station/@internalStation &lt; $endStation]">
                        <tr>
                            <td class="sidepad" align="left"><xsl:call-template name="Number"/></td>
                            <td class="sidepad" align="right">
                                <xsl:value-of select="cif:ordinateFormat(-1*number(GeometryPoint/@easting))"/>
                            </td>
                            <td class="sidepad" align="right">
                                <xsl:value-of select="cif:ordinateFormat(-1*number(GeometryPoint/@northing))"/>
                            </td>
                            <td class="sidepad" align="right">
                                <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@elevation))"/>
                            </td>
                            <td class="sidepad" align="right">
                                <xsl:value-of select="cif:stationFormat(number(GeometryPoint/station/@externalStation), string(GeometryPoint/station/@externalStationName))"/>
                            </td>
                            <td align="right">
                                <xsl:value-of select="cif:directionFormat(number(@tangentialDirection))"/>
                            </td>
                            <td align="right">
                                <xsl:value-of select="cif:distanceFormat(number(@radius))"/>
                            </td>
                        </tr>
                    </xsl:for-each>
                </xsl:for-each>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:for-each select="End">
            <tr>
                <td class="sidepad" align="left"><xsl:call-template name="Number"/></td>
                <td class="sidepad" align="right"><xsl:value-of select="cif:ordinateFormat(-1*number(@easting))"/></td>
                <td class="sidepad" align="right"><xsl:value-of select="cif:ordinateFormat(-1*number(@northing))"/></td>
                <td class="sidepad" align="right"><xsl:value-of select="cif:ordinateFormat(number(@elevation))"/></td>
                <td class="sidepad" align="right" nowrap="nowrap">
                    <xsl:value-of select="cif:stationFormat(number(station/@externalStation), string(station/@externalStationName))"/>
                </td>
                <td align="right">
                    <xsl:value-of select="cif:directionFormat(number(../@tangentialDirectionEnd))"/>
                </td>
                <xsl:choose>
                    <xsl:when test="../@rotationDirection = 'ccw'">
                        <td align="right">
                            <xsl:value-of select="cif:distanceFormat(number(-1 * ../@endRadius))"/>
                        </td>
                    </xsl:when>
                    <xsl:otherwise>
                        <td align="right">
                            <xsl:value-of select="cif:distanceFormat(number(../@endRadius))"/>
                        </td>
                    </xsl:otherwise>
                </xsl:choose>
            </tr>
        </xsl:for-each>
    </xsl:template>

    <xsl:template name="Number">
        <xsl:number count="Start | End | HorizontalEventPoint" level="any"/>
    </xsl:template>
    
    <xsl:template name="StyleSheetHelp">
        <div class="section1">
            <h4 lang="en">Poznámky</h4>
            <p class="normal1" lang="en">
                Pro tento výpis musíte vybrat nejméně jeden Civil směrový prvek. 
                Tento výpis čísluje body za sebou.
            </p>
            <p class="small" lang="en">
                <em>&#xa9; 2012 Bentley Systems, Inc</em>
            </p>
        </div>
    </xsl:template>
</xsl:stylesheet>
